/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.persistence.IPersistenceAttachment;
import frc.emul.api.persistence.IPersistentSection;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class FileAttachment
implements IPersistenceAttachment {
    private final IPersistentSection section;
    private final File source;

    public FileAttachment(IPersistentSection iPersistentSection, String string) {
        this(iPersistentSection, new File(string));
    }

    public FileAttachment(IPersistentSection iPersistentSection, File file) {
        this.section = iPersistentSection;
        this.source = file;
    }

    public IPersistentSection getSection() {
        return this.section;
    }

    public InputStream getContent() {
        if (!this.source.isFile()) {
            return new ByteArrayInputStream(("*** File [" + this.source.getPath() + "] doesn't exist.").getBytes());
        }
        try {
            return new BufferedInputStream(new FileInputStream(this.source));
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(("*** Exception while opening file [" + this.source.getPath() + "] : \n").getBytes());
            }
            catch (IOException iOException) {}
            PrintStream printStream = new PrintStream(byteArrayOutputStream, false);
            exception.printStackTrace(printStream);
            printStream.close();
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
    }
}

